{********************************************
; File: AppleTalk.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT APPLETALK;

INTERFACE

USES TYPES;

CONST
{ Command Numbers }
atGetInfoCommand = $0002;
atGetGlobalCommand = $0003;
atInstallTimerCommand = $0004;
atRemoveTimerCommand = $0005;
atBootCommand = $0006;
atCancelTimerCommand = $0045;

{ Link Access Protocol Codes }
lapWriteCommand = $0007;
lapReadBufferCommand = $0008;
lapAttachProtCommand = $0009;
lapRemoveProtCommand = $000A;

{ Datagram Delivery Protocol Codes }
ddpOpenSocketCommand = $000B;
ddpCloseSocketCommand = $000C;
ddpSendDatagramCommand = $000D;

{ Name Binding Protocol Codes }
nbpRegisterNameCommand = $000E;
nbpRemoveNameCommand = $000F;
nbpLookupNameCommand = $0010;
nbpConfirmNameCommand = $0011;
nbpKillCommand = $0046;

{ AppleTalk Transaction Protocol Codes }
atpSendReqCommand = $0012;
atpCancelReqCommand = $0013;
atpOpenSocketCommand = $0014;
atpCloseSocketCommand = $0015;
atpGetReqCommand = $0016;
atpSendRespCommand = $0017;
atpRelCBCommand = $0019;

{ Zone Information Protocol Codes }
zipGetMyZoneCommand = $001A;
zipGetZoneListCommand = $001B;

{ AppleTalk Session Protocol Codes }
aspGetParmsCommand = $001C;
aspGetStatusCommand = $001D;
aspOpenSessionCommand = $001E;
aspCloseSessionCommand = $001F;
aspCommandCommand = $0020;
aspWriteCommand = $0021;

{ Printer Access Protocol Codes }
papStatusCommand = $0022;
papOpenCommand = $0023;
papCloseCommand = $0024;
papReadCommand = $0025;
papWriteCommand = $0026;
papUnloadCommand = $0027;

{ Remote Print Manager Codes }
rpmSetPrinterCommand = $0028;
rpmCloseSessionCommand = $0047;
rpmFlushSessionCommand = $0048;

{ ProDOS Filing Interface Codes }
pfiUserPrefixCommand = $002A;
pfiLoginCommand = $002B;
pfiLoginContCommand = $002C;
pfiLogOutCommand = $002D;
pfiMountVolCommand = $002E;
pfiListSessionsCommand = $002F;
pfiTimeZoneCommand = $0030;
pfiGetSrcPathCommand = $0031;
pfiAccessCommand = $0032;
pfiNamingCommand = $0033;
pfiConvertTimeCommand = $0034;
pfiSetBufferCommand = $0036;
pfiHooksCommand = $0037;
pfiLogin2Command = $0038;
pfiListSessions2Command = $0039;
pfiGetSVersionCommand = $003A;

{ Error Codes }
appleTalkNetError = $8888; { AppleTalk Network Error }
atInvalidCmdErr = $0101;  { Invalid command }
atMemoryErr = $0102;  { Heap/memory management error }
atTimerNotInstalledErr = $0103;  { No timer installed error }
atSyncErr = $0104;  { Syncronous only call }
atTooManyTimes = $0105;  { Too many times }
atTimerCancelled = $0106;

{ LAP Error Codes }
lapNoPacketErr = $0201;  { No packet in buffer }
lapEOBErr = $0202;  { End of buffer }
lapLenErr = $0203;  { LAP data too large }
lapFailedErr = $0204;  { Retry count exhausted }
lapTypeErr = $0205;  { Illegal LAP type }
lapDuplicateErr = $0206;  { Duplicate LAP type }
lapProtocolErr = $0207;  { Too many protocols }
lapTypeFoundErr = $0208;  { Type not found }
lapDataLostErr = $0209;  { Data lost in Purge }

{ DDP Error Codes }
ddpSktNumErr = $0301;  { Too many sockets open }
ddpSktErr = $0302;  { Socket not open }
ddpSktOpenErr = $0303;  { Socket already open }
ddpSktTypeErr = $0304;  { Invalid Socket Type }
ddpLenErr = $0305;  { DDP length error }
ddpBridgeErr = $0306;  { No bridge available }

{ NBP Error Codes }
nbpNameNumberErr = $0401;  { Too many names }
nbpNameExistErr = $0402;  { Name already exists }
nbpNameFoundErr = $0403;  { Name not found }
nbpBufferErr = $0404;  { User buffer full }
nbpWildcardErr = $0405;  { Wildcard not allowed }
nbpNameErr = $0406;  { Invalid name format }
nbpAddressErr = $0407;  { Incorrect address }
nbpProcessErr = $0408;  { Too many NBP processes }
nbpAbortErr = $0409;  { NBP Aborted }
nbpParmBlkNotFndErr = $040A;  { NBP Param Block not found }

{ ATP Error Codes }
atpDataLenErr = $0501;  { ATP data too large }
atpSocketErr = $0502;  { Invalid ATP socket }
atpControlBlkErr = $0503;  { ATP control block not found }
atpProcessErr = $0504;  { Too many active ATP calls }
atpReleaseErr = $0505;  { No release received }
atpNoRespActive = $0506;  { No response active }
atpRespErr = $0507;  { No send response active }
atpReqErr = $0508;  { ATP send request aborted }
atpSktClosedErr = $0509;  { socket closed error }
atpTooManySkts = $050A;  { Too many ATP sockets }
atpTooManyResp = $050B;  { Too many responses expected }
atpDDPSktErr = $050C;  { Unable to open DDP socket }
atpSndRespRelErr = $050D;  { ATP Send Response was released }

{ ZIP Error Codes }
zipNetworkErr = $0601;  { Network error }
zipOverflow = $0602;  { ZIP overflow }
zipNotFound = $0603;  { ZIP not found }

{ ASP Error Codes }
aspNetworkErr = $0701;  { Network error }
aspSessNumErr = $0702;  { Too many sessions }
aspRefErr = $0703;  { Invalid reference number }
aspSizeErr = $0704;  { Size error }
aspBufErr = $0705;  { Buffer error }
aspNoRespErr = $0706;  { No response from server }
aspBadVersion = $0707;  { Bad version number }
aspTooManySessions = $0708;  { Too many sessions }
aspServBusyErr = $0709;  { Server busy }
aspSessionClosed = $070A;  { Session closed }

{ PAP Error Codes }
papSessNumErr = $0801;  { Too many sessions }
papRefErr = $0802;  { Invalid Reference }
papQuantumErr = $0803;  { Quantum Error }
papCommandErr = $0804;  { Too many commands }
papNameErr = $0805;  { Name not found }
papSessionErr = $0806;  { Session closed }
papNetworkErr = $0807;  { Network error }
papServRespErr = $0808;  { Server not responding }
papServBusyErr = $0809;  { Server busy }
papBuffSizeErr = $080A;  { Buffer size error }
papInUseErr = $080B;  { PAP in use }

{ RPM Error Codes }
rpmInvalidFlagErr = $0901;
rpmInvalidTimeErr = $0902;

{ PFI Error Codes }
pfiTooManySessErr = $0A01;  { Too many sessions }
pfiUnableOpenSessErr = $0A02;  { Unable to open session }
pfiNoRespFrmSrvrErr = $0A03;  { No response from server }
pfiLoginContErr = $0A04;  { Login continue }
pfiInvalidNameErr = $0A05;  { Invalid name }
pfiInvalidSessNumErr = $0A06;  { Invalid Sess reference # or unknown volume }
pfiUnableOpenVolErr = $0A07;  { Unable to open volume }
pfiTooManyVolsOpenErr = $0A08;  { Too many mounted volumes }
pfiVolNotMountedErr = $0A09;  { Volume Not Mounted }
pfiUnableSetCreatorErr = $0A0A;
pfiBufferToSmallErr = $0A0B;  { Buffer to small }
pfiTimeFlagErr = $0A0C;  { Time flag error }
pfiUnableTSetGroupErr = $0A0D;  { Unable to set group }
pfiDirNotFoundErr = $0A0E;  { Directory not found }
pfiAccessDeniedErr = $0A0F;  { Access denied }
pfiMiscellaneousErr = $0A10;  { Miscellaneous error }
pfiVolAlreadyMntedErr = $0A11;  { Volume already mounted }
pfiUnableGetCreatorErr = $0A12;  { Unable to get creator/group }
pfiAlrdyLggedOnSrvrErr = $0A13;  { Already logged onto server }
pfiTimeError = $0A14;  { Time error }
pfiUserNotAuthorizedErr = $0A15;  { User not authorized }
pfiParamterErr = $0A16;  { Parameter error }
pfiSrvrGoingDownErr = $0A17;  { Server going down }
pfiBadUAMErr = $0A18;  { Bad UAM }
pfiBadVersionNumErr = $0A19;  { Bad version number }

{ ATInit offsets }
atInitUserName = $0085;
atInitPrinterFlags = $0064;
atInitPrinterTuple = $0063;
atInitPrefix = $00C6;
atInitPrefixDirID = $00CA;
atInitPrefixVolID = $00CC;
atInitPath = $010D;
atInitPathDirID = $0111;
atInitPathVolID = $0113;

{ ATGetInfoRec.hardwareID flags }
hidAppleIIGS = $0000;

{ ATInstallTimerRec.ticksToComplete values  }
atMaxTicks = $FFFF;
atMaxTicksIIe = $1FFF;

{ LAPReadBufferRec.purge values }
lapPurgeOff = $0000;
lapPurgeOn = $0001;

{ DDPSendDatagramRec.checksum values }
ddpChecksumOff = $00;
{$IFC UNDEFINED ddpChecksumOn }
ddpChecksumOn = $01;
{$SETC ddpChecksumOn := 0}
{$ENDC}

{ NBPRegsterNameRec.checkFlag values }
nbpCheckNameOn = $00;
nbpCheckNameOff = $01;

{
    ATPSendReqRec.atpFlags and 
    ATPGetReqRec.atpFlags values
}

atpExactlyOnceMask = $20;

{ ATPSendReqRec.result value (low byte) }
atpExecuting = $FF;

{ ATPOpenSocketRec.socketID values }
atpDynamicSocket = $00;

{ ASPAttenHeaderRec.attenType values }
aspAttenNormal = $00;
{$IFC UNDEFINED aspAttenTimeout }
aspAttenTimeout = $40;
{$SETC aspAttenTimeout := 0}
{$ENDC}
aspAttenClosed = $80;

{ RPMSetPrinterRec.timeOut values }
{$IFC UNDEFINED rpmTimeOutOff }
rpmTimeOutOff = $0000;
{$SETC rpmTimeOutOff := 0}
{$ENDC}

{ RPMSetPrinterRec.rpmFlags masks }
rpmNetworkMask = $80;
rpmPostscriptMask = $20;
{$IFC UNDEFINED rpmReturnNameMask }
rpmReturnNameMask = $01;
{$SETC rpmReturnNameMask := 0}
{$ENDC}

{ PFIMountVolRec.mountFlag masks }
pfiMountMask = $80;
{$IFC UNDEFINED pfiPasswordMask }
pfiPasswordMask = $40;
{$SETC pfiPasswordMask := 0}
{$ENDC}
{$IFC UNDEFINED pfiUserVolumeMask }
pfiUserVolumeMask = $01;
{$SETC pfiUserVolumeMask := 0}
{$ENDC}

{ PFITimeZoneRec.timeFlag masks }
{$IFC UNDEFINED pfiEastWestMask }
pfiEastWestMask = $80;
{$SETC pfiEastWestMask := 0}
{$ENDC}
pfiHoursAwayMask = $7F;

{ PFIAccessRec.directionalFlag masks }
pfiSetAccessMask = $80;
pfiCreatorMask = $40;
pfiGroupMask = $20;

{ PFINamingRec masks }
pfiDNCMask = $80;  { PFI Directional Naming Convention Mask }
pfiDDTMask = $40;  { PFI Directional Device Table Mask }
pfiNNCMask = $80;  { PFI Naming Naming Convention Mask }
pfiNDTMask = $40;  { PFI Naming Device Table Mask }

{ LAPAttachProtRec.protType values }
lapProtTypeMin = $01;
lapProtTypeMax = $7F;
lapProtTypeAll = $FF;

{ Socket Range values }
atpSocketDynamicMin = $80;
atpSocketDynamicMax = $FE;
atpSocketStaticMin = $01;
atpSocketStaticMax = $7F;

{ Buffer length constants }
zipGetMyZoneBufLenMin = $21;
papOpenStatusBufLenMin = $0104;
pfiUserNameLenMax = $0040;

{ Other misc constants }
{$IFC UNDEFINED workstationGS }
workstationGS = $0000;
{$SETC workstationGS := 0}
{$ENDC}
endOfBDS = $FFFF;
ddpInvalidClient = $00;
atpActualLengthMask = $7FFF;
atpActualLengthOvflw = $8000;
atpUnusedAddRtnPtr = $00000000;
atpUnusedAddBitMap = $00;
pfiAFPVersion11 = $0101;
pfiAFPVersion20 = $0200;
pfiAFPTimeFormat = $0000;
pfiProDOSTimeFormat = $0001;
pfiHooksSetHooks = $40;
pfiHooksP8Active = $80;
pfiSetWriteBuffer = $80;
papReadNotEOF = $00;

TYPE
EntName = RECORD
    buffer : PACKED ARRAY[1..99] OF Byte;
END;

GetMyZoneBuf = PACKED ARRAY [1..zipGetMyZoneBufLenMin] of Byte;
PAPOpenStatusBuf = PACKED ARRAY [1..papOpenStatusBufLenMin] of Byte;
PFIUserName = PACKED ARRAY [1..pfiUserNameLenMax] of Byte;

ATInitTailRecHndl = ^ATInitTailRecPtr;
ATInitTailRecPtr = ^ATInitTailRec;
ATInitTailRec = PACKED RECORD
    pathVolID : Integer;
    pathDirID : Longint;
    path : PACKED ARRAY[1..65] OF CHAR;
    prefixVolID : Integer;
    prefixDirID : Longint;
    prefix : PACKED ARRAY[1..65] OF CHAR;
    userName : PACKED ARRAY[1..33] OF CHAR;
    printerFlags : Byte;
    printerTuple : PACKED ARRAY[1..99] OF Byte;
END;

ATGetInfoRecHndl = ^ATGetInfoRecPtr;
ATGetInfoRecPtr = ^ATGetInfoRec;
ATGetInfoRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    completionRtn : Longint;
    thisNet : Integer;
    aBridge : Byte;
    hardwareID : Byte;
    romVersion : Integer;
    nodeNumber : Byte;
END;

ATGetGlobalRecHndl = ^ATGetGlobalRecPtr;
ATGetGlobalRecPtr = ^ATGetGlobalRec;
ATGetGlobalRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    bufferPtr : Ptr;
END;

ATGetGlobalBufferHndl = ^ATGetGlobalBufferPtr;
ATGetGlobalBufferPtr = ^ATGetGlobalBuffer;
ATGetGlobalBuffer = PACKED RECORD
    destinationNode : Byte;
    lapSourceNode : Byte;
    lapType : Byte;
    hopCountDL : Byte;
    datagramLength : Byte;
    ddpChecksum : Integer;
    destNetwork : Integer;
    sourceNetwork : Integer;
    destinationNode : Byte;
    sourceNode : Byte;
    destinationSocket : Byte;
    sourceSocket : Byte;
    ddpType : Byte;
    packetLength : Integer;
END;

ATInstallTimerRecHndl = ^ATInstallTimerRecPtr;
ATInstallTimerRecPtr = ^ATInstallTimerRec;
ATInstallTimerRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    completionRtn : Longint;
    runningTickCount : Integer;
    ticksToComplete : Integer;
    reserved : Ptr;
END;

ATRemoveTimerRecHndl = ^ATRemoveTimerRecPtr;
ATRemoveTimerRecPtr = ^ATRemoveTimerRec;
ATRemoveTimerRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    reserved : PACKED ARRAY[1..12] OF Byte;
END;

ATBootRecHndl = ^ATBootRecPtr;
ATBootRecPtr = ^ATBootRec;
ATBootRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
END;

ATCancelTimerRecHndl = ^ATCancelTimerRecPtr;
ATCancelTimerRecPtr = ^ATCancelTimerRec;
ATCancelTimerRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    reserved : PACKED ARRAY[1..12] OF Byte;
END;

ASPAttentionHeaderRecHndl = ^ASPAttentionHeaderRecPtr;
ASPAttentionHeaderRecPtr = ^ASPAttentionHeaderRec;
ASPAttentionHeaderRec = PACKED RECORD
    sessionRefNum : Byte;
    attenType : Byte;
    atten : Integer;
END;

ASPGetParmsRecHndl = ^ASPGetParmsRecPtr;
ASPGetParmsRecPtr = ^ASPGetParmsRec;
ASPGetParmsRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    maxCmdSize : Integer;
    maxDataSize : Integer;
END;

ASPGetStatusRecHndl = ^ASPGetStatusRecPtr;
ASPGetStatusRecPtr = ^ASPGetStatusRec;
ASPGetStatusRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    slsNet : Integer; { SLS Network Number }
    slsNode : Byte; { SLS Node Number }
    slsSocket : Byte; { SLS Socket Number }
    bufferLength : Integer; { Buffer Length }
    bufferAddr : Longint; { Buffer Address }
    dataLength : Integer; { Length of Status Data }
END;

ASPOpenSessionRecHndl = ^ASPOpenSessionRecPtr;
ASPOpenSessionRecPtr = ^ASPOpenSessionRec;
ASPOpenSessionRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    slsNet : Integer; { SLS Network Number }
    slsNode : Byte; { SLS Node Number }
    slsSocket : Byte; { SLS Socket Number }
    attnRtnAddr : Longint; { Attention Routine Addr }
    refNum : Byte; { Session Reference Number }
END;

ASPCloseSessionRecHndl = ^ASPCloseSessionRecPtr;
ASPCloseSessionRecPtr = ^ASPCloseSessionRec;
ASPCloseSessionRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    refNum : Byte; { Session Reference Number }
END;

ASPCommandRecHndl = ^ASPCommandRecPtr;
ASPCommandRecPtr = ^ASPCommandRec;
ASPCommandRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    refNum : Byte; { Session Reference Number }
    cmdBlkLength : Integer; { Command Block Length }
    cmdBlkAddr : Longint; { Command Block Address }
    replyBufferLen : Integer; { Reply Buffer Length }
    replyBufferAddr : Longint; { Reply Buffer Address }
    cmdResult : Longint; { Command Result }
    replyLength : Integer; { Reply Length }
END;

ASPWriteRecHndl = ^ASPWriteRecPtr;
ASPWriteRecPtr = ^ASPWriteRec;
ASPWriteRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    refNum : Byte; { Session Reference Number }
    cmdBlkLength : Integer; { Command Block Length }
    cmdBlkAddr : Longint; { Command Block Address }
    writeDataLength : Integer; { Write Data Length }
    writeDataAddr : Longint; { Write Data Address }
    replyBufferLen : Integer; { Reply Buffer Length }
    replyBufferAddr : Longint; { Reply Buffer Address }
    cmdResult : Longint; { Command Result }
    writtenLength : Integer; { Written Length }
    replyLength : Integer; { Reply Length }
END;

ServerHndl = ^ServerPtr;
ServerPtr = ^Server;
Server = PACKED RECORD
    serverName : Ptr; { Pointer to a Server Entity }
    net : Integer; { Net of the server }
    node : Byte; { Node of the server }
    socket : Byte; { Socket number of the server }
END;

ATPSendReqRecHndl = ^ATPSendReqRecPtr;
ATPSendReqRecPtr = ^ATPSendReqRec;
ATPSendReqRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ATP command to execute }
    result : Integer; { error result from the ATP operation }
    completionPtr : Longint; { pointer to the completion routine }
    socketID : Byte; { dynamic socket number }
    destNetID : Integer; { destination network # }
    destNodeID : Byte; { destination node # }
    destSocketID : Byte; { destination socket # }
    transactionID : Integer; { transaction ID # }
    reqBufferLength : Integer; { request buffer length }
    reqBufferPtr : Longint; { pointer to the request buffer }
    userBytes : Longint; { user BYTEs }
    numberRespBuffers : Byte; { number of response buffers }
    respBufferPtr : Longint; { pointer to the response buffer }
    atpFlags : Byte; { flags for ATP transaction }
    rInterval : Byte; { timeout before retrying }
    rCount : Byte; { number of retries to attempt }
    bitMap : Byte; { bitmap indicating for packet reception }
    responseRcv : Byte; { number of responses received }
    reserved : Byte; { reserved for future use }
END;

ATPCancelReqRecHndl = ^ATPCancelReqRecPtr;
ATPCancelReqRecPtr = ^ATPCancelReqRec;
ATPCancelReqRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ATP command to execute }
    result : Integer; { error result from ATP operation }
    transactionID : Integer; { transaction ID # }
END;

ATPOpenSocketRecHndl = ^ATPOpenSocketRecPtr;
ATPOpenSocketRecPtr = ^ATPOpenSocketRec;
ATPOpenSocketRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ATP command to execute }
    result : Integer; { error result from the ATP operation }
    socketID : Byte; { socket number to open }
END;

ATPCloseSocketRecHndl = ^ATPCloseSocketRecPtr;
ATPCloseSocketRecPtr = ^ATPCloseSocketRec;
ATPCloseSocketRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ATP command to execute }
    result : Integer; { error result from ATP operation }
    socketID : Byte; { socket number for closing }
END;

ATPGetReqRecHndl = ^ATPGetReqRecPtr;
ATPGetReqRecPtr = ^ATPGetReqRec;
ATPGetReqRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ATP command to execute }
    result : Integer; { error result from ATP operation }
    completionPtr : Longint; { pointer to the completion routine }
    respSocketID : Byte; { response socket # }
    networkID : Integer; { source network # }
    nodeID : Byte; { source node # }
    socketID : Byte; { source socket # }
    transactionID : Integer; { ATP transaction ID }
    reqBufferLength : Integer; { request buffer length }
    reqBufferPtr : Longint; { pointer to request buffer }
    userBytes : Longint; { user BYTEs }
    requestLength : Integer; { actual request length }
    atpFlags : Byte; { ATP operation flags }
    bitMap : Byte; { bitmap for packet reception }
    reserved : Longint; { reserved for future use }
END;

ATPSendRespRecHndl = ^ATPSendRespRecPtr;
ATPSendRespRecPtr = ^ATPSendRespRec;
ATPSendRespRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ATP command to execute }
    result : Integer; { result to the ATP operation }
    completionPtr : Longint; { pointer to the completion routine }
    socketID : Byte; { response socket # }
    destNetID : Integer; { destination network # }
    destNodeID : Byte; { destination node # }
    destSocketID : Byte; { destination socket # }
    transactionID : Integer; { transaction ID # }
    numRespBuffers : Byte; { number of response buffers }
    totalPackets : Byte; { total ATP packets }
    respBDSPtr : Longint; { pointer to the BDS buffer }
    atpFlags : Byte; { ATP operation flags }
    bitmap : Byte; { bitmap for packet reception }
    reserved : Longint; { must be set to NIL for future compatibility }
    reserved2 : Byte; { must be set to 0 for future compatibility }
END;

ATPRelCBRecHndl = ^ATPRelCBRecPtr;
ATPRelCBRecPtr = ^ATPRelCBRec;
ATPRelCBRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ATP command to execute }
    result : Integer; { error result to the ATP operation }
    socketID : Byte; { response socket # }
    destNetID : Integer; { destination network # }
    destNodeID : Byte; { destination node # }
    destSocketID : Byte; { destination socket # }
    transactionID : Integer; { ATP transaction ID }
END;

RespBDSBufferHndl = ^RespBDSBufferPtr;
RespBDSBufferPtr = ^RespBDSBuffer;
RespBDSBuffer = RECORD
    bufferLength : Integer;
    bufferPtr : Longint;
    userBytes : Longint;
    actualLength : Integer;
END;

DDPOpenSocketRecHndl = ^DDPOpenSocketRecPtr;
DDPOpenSocketRecPtr = ^DDPOpenSocketRec;
DDPOpenSocketRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { DDP command to execute }
    result : Integer; { error result from DDP operation }
    socketNumber : Byte; { socket number opened }
    clientAddr : Longint; { client address }
END;

DDPCloseSocketRecHndl = ^DDPCloseSocketRecPtr;
DDPCloseSocketRecPtr = ^DDPCloseSocketRec;
DDPCloseSocketRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { DDP commnd to execute }
    result : Integer; { error result from DDP operation }
    socketNumber : Byte; { socket # to close }
END;

DDPSendDatagramRecHndl = ^DDPSendDatagramRecPtr;
DDPSendDatagramRecPtr = ^DDPSendDatagramRec;
DDPSendDatagramRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { DDP command to execute }
    result : Integer; { error result from DDP operation }
    checksum : Byte; { calculated checksum }
    destNet : Integer; { destination network # }
    destNode : Byte; { destination node # }
    destSocket : Byte; { destination socket # }
    sourceSocket : Byte; { DDP socket to send from }
    ddpType : Byte; { DDP protocol type }
    bdsPtr : Longint; { pointer to the DDP BDS buffer }
END;

LAPWriteRecHndl = ^LAPWriteRecPtr;
LAPWriteRecPtr = ^LAPWriteRec;
LAPWriteRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { lap command to execute }
    result : Integer; { lap error result code }
    destNode : Byte; { destination node to send packet to }
    lapType : Byte; { lap protocol type to send }
    lapBDSPtr : Longint; { pointer to the lap BDS buffer }
END;

LAPReadBufferRecHndl = ^LAPReadBufferRecPtr;
LAPReadBufferRecPtr = ^LAPReadBufferRec;
LAPReadBufferRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { LAP command to execute }
    result : Integer; { error result of the LAP operation }
    requestCount : Integer; { how many BYTEs to transfer }
    bufferPtr : Longint; { pointer to a buffer to store info }
    purge : Byte; { flag for purging the buffer if wrong size }
    amountTransfered : Integer; { actual amount transfered }
END;

LAPAttachProtRecHndl = ^LAPAttachProtRecPtr;
LAPAttachProtRecPtr = ^LAPAttachProtRec;
LAPAttachProtRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { LAP command to execute }
    result : Integer; { error result of LAP operation }
    protType : Byte; { protocol type specifing the LAP type }
    protAddr : Longint; { protocol address specifing the LAP handler }
END;

LAPRemoveProtRecHndl = ^LAPRemoveProtRecPtr;
LAPRemoveProtRecPtr = ^LAPRemoveProtRec;
LAPRemoveProtRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { LAP command to execute }
    result : Integer; { error result of LAP operation }
    protType : Byte; { protocol type specifing the LAP type }
END;

BDSHndl = ^BDSPtr;
BDSPtr = ^BDS;
BDS = RECORD
    BufferLength : Integer;
    BufferPtr : Longint;
END;

NBPRNEntityNameRecHndl = ^NBPRNEntityNameRecPtr;
NBPRNEntityNameRecPtr = ^NBPRNEntityNameRec;
NBPRNEntityNameRec = RECORD
    reserved : PACKED ARRAY[1..9] OF Byte;
    entityName : EntName;
END;

NBPLUNameBufferRecHndl = ^NBPLUNameBufferRecPtr;
NBPLUNameBufferRecPtr = ^NBPLUNameBufferRec;
NBPLUNameBufferRec = PACKED RECORD
    netNum : Integer;
    nodeNum : Byte;
    socketNum : Byte;
    enumerator : Byte;
    entityName : EntName;
END;

NBPRegisterNameRecHndl = ^NBPRegisterNameRecPtr;
NBPRegisterNameRecPtr = ^NBPRegisterNameRec;
NBPRegisterNameRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { NBP command to execute }
    result : Integer; { error result from NBP operation }
    completionPtr : Longint; { pointer to the completion routine }
    namePtr : Longint; { pointer to the entityType }
    rInterval : Byte; { timeOut period before retrying }
    rCount : Byte; { number of retries to attempt }
    reserved : Integer; { reserved for future use }
    socketNumber : Byte; { socket listner being registered }
    checkFlag : Byte; { flag for checking duplicate names }
END;

NBPRemoveNameRecHndl = ^NBPRemoveNameRecPtr;
NBPRemoveNameRecPtr = ^NBPRemoveNameRec;
NBPRemoveNameRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { NBP command to execute }
    result : Integer; { error result from NBP operation }
    entityPtr : Longint; { pointer to the entity entityType }
END;

NBPLookupNameRecHndl = ^NBPLookupNameRecPtr;
NBPLookupNameRecPtr = ^NBPLookupNameRec;
NBPLookupNameRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { NBP command to execute }
    result : Integer; { error result from NBP operation }
    completionPtr : Longint; { pointer to the completion routine }
    entityPtr : Longint; { pointer to the entity entityType }
    rInterval : Byte; { timeout interval before retrying }
    rCount : Byte; { number of retries to attempt }
    reserved : Integer; { reserved for future use }
    bufferLength : Integer; { length of the user buffer }
    bufferPtr : Longint; { pointer to the user buffer }
    maxMatch : Byte; { maxiumn number of name matches }
    actualMatch : Byte; { actual number of matches }
END;

NBPConfirmNameRecHndl = ^NBPConfirmNameRecPtr;
NBPConfirmNameRecPtr = ^NBPConfirmNameRec;
NBPConfirmNameRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { NBP command to execute }
    result : Integer; { error result from NBP operation }
    completionPtr : Longint; { pointer to the completion routine }
    entityPtr : Longint; { pointer to the entity name }
    rInterval : Byte; { timeout interval before retrying }
    rCount : Byte; { number of retries to attempt }
    reserved : Integer; { reserved for future use }
    networkID : Integer; { network number for confirmation }
    nodeID : Byte; { node number for confirmation }
    socketID : Byte; { socket number for confirmation }
    actualSocketID : Byte; { actual socket number confirmed }
END;

NBPKillRecHndl = ^NBPKillRecPtr;
NBPKillRecPtr = ^NBPKillRec;
NBPKillRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    paramBlockPtr : Ptr;
END;

PAPStatusRecHndl = ^PAPStatusRecPtr;
PAPStatusRecPtr = ^PAPStatusRec;
PAPStatusRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    printerNamePtr : Longint; { pointer to the printer name }
    statusBufferPtr : Longint; { pointer to the status buffer }
END;

PAPOpenRecHndl = ^PAPOpenRecPtr;
PAPOpenRecPtr = ^PAPOpenRec;
PAPOpenRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    sessRefID : Byte; { session reference number }
    printerNamePtr : Longint; { printer name pointer }
    flowQuantum : Byte; { number of ATP packets to be sent }
    statusBufferPtr : Longint; { pointer to the status buffer }
END;

PAPCloseRecHndl = ^PAPCloseRecPtr;
PAPCloseRecPtr = ^PAPCloseRec;
PAPCloseRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    sessRefID : Byte; { session referance number }
END;

PAPReadRecHndl = ^PAPReadRecPtr;
PAPReadRecPtr = ^PAPReadRec;
PAPReadRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    sessRefID : Byte; { session reference # }
    bufferLength : Integer; { length of the user buffer }
    bufferPtr : Longint; { pointer to the user buffer }
    papEOF : Byte; { end of file flag }
END;

PAPWriteRecHndl = ^PAPWriteRecPtr;
PAPWriteRecPtr = ^PAPWriteRec;
PAPWriteRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
    sessRefID : Byte; { session reference # }
    dataLength : Integer; { data length }
    bufferPtr : Longint; { pointer to the buffer }
    papEOF : Byte; { end of file flag }
END;

PAPUnloadRecHndl = ^PAPUnloadRecPtr;
PAPUnloadRecPtr = ^PAPUnloadRec;
PAPUnloadRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PAP command to execute }
    result : Integer; { error result from a PAP operation }
    completionPtr : Longint; { pointer to the completion routine }
END;

PFIAttentionHeaderRecHndl = ^PFIAttentionHeaderRecPtr;
PFIAttentionHeaderRecPtr = ^PFIAttentionHeaderRec;
PFIAttentionHeaderRec = PACKED RECORD
    sessionRefNum : Byte;
    attenType : Byte;
    atten : Integer;
    serverName : PACKED ARRAY[1..33] OF CHAR;
    zoneName : PACKED ARRAY[1..34] OF CHAR;
END;

PFIHooksMountingRecHndl = ^PFIHooksMountingRecPtr;
PFIHooksMountingRecPtr = ^PFIHooksMountingRec;
PFIHooksMountingRec = PACKED RECORD
    sessionRefNum : Byte;
    p8UnitNum : Byte;
    volumeName : PACKED ARRAY[1..29] OF CHAR;
    volumeID : Integer;
    serverName : PACKED ARRAY[1..33] OF CHAR;
    zoneName : PACKED ARRAY[1..34] OF CHAR;
END;

PFIUserPrefixRecHndl = ^PFIUserPrefixRecPtr;
PFIUserPrefixRecPtr = ^PFIUserPrefixRec;
PFIUserPrefixRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    directionFlag : Byte; { high bit set to point to by User Pointer is stored in PFI }
    userNamePtr : Integer; { name pointed to my User Mane Pointer }
END;

PFILoginRecHndl = ^PFILoginRecPtr;
PFILoginRecPtr = ^PFILoginRec;
PFILoginRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    networkID : Integer; { network number for confirmation }
    nodeID : Byte; { node number for confirmation }
    socketID : Byte; { socket number for confirmation }
    cmdBufferLength : Integer; { length of the user command buffer }
    cmdBufferPtr : Longint; { pointer to the user command buffer }
    replyBufferLen : Integer; { length of the reply buffer }
    replyBufferPtr : Longint; { pointer to the reply buffer }
    sessRefID : Byte; { session reference number }
    attnRtnAddr : Longint;
END;

PFILoginContRecHndl = ^PFILoginContRecPtr;
PFILoginContRecPtr = ^PFILoginContRec;
PFILoginContRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    sessRefID : Byte; { session reference number }
    cmdBufferLength : Integer; { length of the user command buffer }
    cmdBufferPtr : Longint; { pointer to the user command buffer }
    replyBufferLen : Integer; { length of the reply buffer }
    replyBufferPtr : Longint; { pointer to the reply buffer }
END;

PFILogoutRecHndl = ^PFILogoutRecPtr;
PFILogoutRecPtr = ^PFILogoutRec;
PFILogoutRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    sessRefID : Byte; { session reference number }
END;

PFIMountvolRecHndl = ^PFIMountvolRecPtr;
PFIMountvolRecPtr = ^PFIMountvolRec;
PFIMountvolRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    sessRefID : Byte; { session reference number }
    mountflag : Byte; { mount flag field specifies whether the vol is to be mounted }
    volNamePtr : Longint; { pointer to the volume that will be pseudo-mounted }
    volID : Integer; { volume ID returned by AFP }
    slotDrive : Byte; { the slot/drive in ProDOS format into which the volume was pseudo-mounted }
    passwordPtr : Longint; { pointer to password for the pseudo-mounted volume }
END;

PFIListBufferRecHndl = ^PFIListBufferRecPtr;
PFIListBufferRecPtr = ^PFIListBufferRec;
PFIListBufferRec = PACKED RECORD
    sessionRefNum : Byte;
    Slot : Byte;
    volumeName : PACKED ARRAY[1..28] OF Byte;
    volumeID : Integer;
END;

PFIListSessionsRecHndl = ^PFIListSessionsRecPtr;
PFIListSessionsRecPtr = ^PFIListSessionsRec;
PFIListSessionsRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    bufferLength : Integer; { length of the user buffer }
    bufferPtr : Longint; { pointer to the user buffer }
    entriesRtn : Byte; { contains the number of entries returned from the list of current sessions being maintained through the PFI and any volumes mounted for those sessions }
END;

PFITimeZoneRecHndl = ^PFITimeZoneRecPtr;
PFITimeZoneRecPtr = ^PFITimeZoneRec;
PFITimeZoneRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    timeFlag : Byte; { depending on bit set of the time falg field indicates whether the time should be added to or subtracted from the time zone selected }
END;

PFIGetSrcpathRecHndl = ^PFIGetSrcpathRecPtr;
PFIGetSrcpathRecPtr = ^PFIGetSrcpathRec;
PFIGetSrcpathRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    bufferPtr : Longint; { pointer to the user buffer where the pathname will be placed }
END;

PFIAccessRecHndl = ^PFIAccessRecPtr;
PFIAccessRecPtr = ^PFIAccessRec;
PFIAccessRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    directionalFlag : Byte; { if bit 7 of the directional flag is set, the access is being set }
    accessRights : Longint; { access rights in AFP format }
    pathnamePtr : Longint; { pointer the path name containing that volume }
    creatorNamePtr : Longint; { if bit 6 of the directional flag is set, the creator's name will be dealt with }
    groupNamePtr : Longint; { if bit 5 of the directional flag is set, the group name will be dealt with }
END;

PFINamingRecHndl = ^PFINamingRecPtr;
PFINamingRecPtr = ^PFINamingRec;
PFINamingRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    directionalFlag : Byte; { if bit 7 of the directional flag is set, the naming convention is being set }
    namingConvFlag : Byte; { if bit 7 of the naming convention flag is set, the naming convention becomes AFP format }
END;

PFIConvertTimeRecHndl = ^PFIConvertTimeRecPtr;
PFIConvertTimeRecPtr = ^PFIConvertTimeRec;
PFIConvertTimeRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    formatFlag : Byte; { if the format flag is set to 0, then from date time is AFP format  if the format flag is set to 1, then from date time is ProDOS format }
    fromDateTime : Longint; { this field contains the From DATE/Time data (values) to convert, not pointers }
    toDateTime : Longint; { this field contains the TO DATE/Time data (values) to convert, not pointers }
END;

PFISetBufferRecHndl = ^PFISetBufferRecPtr;
PFISetBufferRecPtr = ^PFISetBufferRec;
PFISetBufferRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { PFI command to execute }
    result : Integer; { error result from PFI operation }
    dirFlag : Byte; { $00 or $80 }
    bufferLength : Integer; { Buffer Length }
    bufferPtr : Longint; { if the format flag is set to 0, then from date time is AFP format }
END;

PFIHooksRecHndl = ^PFIHooksRecPtr;
PFIHooksRecPtr = ^PFIHooksRec;
PFIHooksRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    hookFlag : Byte;
    mountVector : Longint;
    unmountVector : Longint;
    attentionVector : Longint;
END;

PFILogin2RecHndl = ^PFILogin2RecPtr;
PFILogin2RecPtr = ^PFILogin2Rec;
PFILogin2Rec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    networkID : Integer;
    nodeID : Byte;
    socketID : Byte;
    cmdBufferLength : Integer;
    cmdBufferPtr : Longint;
    replyBufferLen : Integer;
    replyBufferPtr : Longint;
    sessRefID : Byte;
    attnRtnAddr : Longint;
    serverName : Ptr;
    zoneName : Ptr;
    afpVersionNum : Integer;
END;

PFIListSessions2RecHndl = ^PFIListSessions2RecPtr;
PFIListSessions2RecPtr = ^PFIListSessions2Rec;
PFIListSessions2Rec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    bufferLength : Integer;
    bufferPtr : Longint;
    entriesRtn : Byte;
END;

PFIGetSVersionRecHndl = ^PFIGetSVersionRecPtr;
PFIGetSVersionRecPtr = ^PFIGetSVersionRec;
PFIGetSVersionRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
    sessRefID : Byte;
    afpVersionNum : Integer;
END;

ListSessionsBufferHndl = ^ListSessionsBufferPtr;
ListSessionsBufferPtr = ^ListSessionsBuffer;
ListSessionsBuffer = PACKED RECORD
    refNum : Byte;
    slotDrive : Byte;
    volName : PACKED ARRAY[1..28] OF CHAR;
    volID : Integer;
END;

RPMSetPrinterRecHndl = ^RPMSetPrinterRecPtr;
RPMSetPrinterRecPtr = ^RPMSetPrinterRec;
RPMSetPrinterRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { RPM command to execute }
    result : Integer; { error code returned from RPM operation }
    entityPtr : Longint; { pointer to the entity name }
    rpmFlags : Byte; { RPM operation flags }
    flushInterval : Integer; { flush interval }
    timeOut : Integer; { timeOut }
    numberBuffers : Integer; { number of buffers allocated }
END;

RPMCloseSessionRecHndl = ^RPMCloseSessionRecPtr;
RPMCloseSessionRecPtr = ^RPMCloseSessionRec;
RPMCloseSessionRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Integer;
END;

RPMFlushSessionRecHndl = ^RPMFlushSessionRecPtr;
RPMFlushSessionRecPtr = ^RPMFlushSessionRec;
RPMFlushSessionRec = PACKED RECORD
    async : Byte;
    command : Byte;
    result : Byte;
END;

ZIPGetMyZoneRecHndl = ^ZIPGetMyZoneRecPtr;
ZIPGetMyZoneRecPtr = ^ZIPGetMyZoneRec;
ZIPGetMyZoneRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ZIP Command to execute }
    result : Integer; { error result from a ZIP operation }
    completionPtr : Longint; { Pointer to the completion routine }
    bufferPtr : Longint; { pointe to the buffer }
    timeOut : Byte; { timeout interval for retrying }
    retry : Byte; { number of retries to attempt }
    reserved : Integer; { reserved for future use }
END;

ZIPGetZoneListRecHndl = ^ZIPGetZoneListRecPtr;
ZIPGetZoneListRecPtr = ^ZIPGetZoneListRec;
ZIPGetZoneListRec = PACKED RECORD
    async : Byte; { asyncronous flag }
    command : Byte; { ZIP command to execute }
    result : Integer; { error result from a ZIP operation }
    completionPtr : Longint; { pointer to the completion routine }
    bufferLength : Integer; { length of the user buffer }
    bufferPtr : Longint; { pointer to the user buffer }
    bridgeNodeID : Byte; { bridge node number }
    startIndex : Integer; { starting index of the buffer }
    timeOut : Byte; { timeout interval for retrying }
    retry : Byte; { number of retries to attempt }
    zonesFound : Integer; { number of zones found }
    reserved : Integer; { reserved for future use (not clear in manual) }
END;

CmdBlockHndl = ^CmdBlockPtr;
CmdBlockPtr = ^CmdBlock;
CmdBlock = RECORD
    cmdLength : Integer; { AFP Command Length }
    cmdBlkAddr : Ptr; { Address of AFP Command }
    replyLength : Integer; { Size of Reply Buffer }
    replyBuffer : Ptr; { Address of Reply Buffer }
    writeLength : Integer; { Size of Data to be written }
    writeBuffer : Ptr; { Address of Write Buffer }
END;

{
    Causes packet and timer interrupts to be buffered without
    being dispatched.  Use with completion routines, socket
    listeners, and in place of disabling interrupts.
}
PROCEDURE RamForbid; INLINE $E1101822;


{
    Reenables packet and timer interrupts. 
    Call after RamForbid.
}
PROCEDURE RamPermit; INLINE $E1101C22;


{
    AppleTalk calls return result value of type OSErr.
    This value is valid only for calls that are made syncronously.
}

FUNCTION  ASPCloseSession (VAR pBlockPtr:ASPCloseSessionRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ASPCommand (VAR pBlockPtr:ASPCommandRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ASPGetParms (VAR pBlockPtr:ASPGetParmsRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ASPGetStatus (VAR pBlockPtr:ASPGetStatusRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ASPOpenSession (VAR pBlockPtr:ASPOpenSessionRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ASPWrite (VAR pBlockPtr:ASPWriteRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATBoot (VAR pBlockPtr:ATBootRecPtr) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATCancelTimer (VAR pBlockPtr:ATCancelTimerRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATGetGlobal (VAR pBlockPtr:ATGetGlobalRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATGetInfo (VAR pBlockPtr:ATGetInfoRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATInstallTimer (VAR pBlockPtr:ATInstallTimerRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATPCancelReq (VAR pBlockPtr:ATPCancelReqRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATPCloseSocket (VAR pBlockPtr:ATPCloseSocketRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATPGetReq (VAR pBlockPtr:ATPGetReqRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATPOpenSocket (VAR pBlockPtr:ATPOpenSocketRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATPRelCB (VAR pBlockPtr:ATPRelCBRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATPSendReq (VAR pBlockPtr:ATPSendReqRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATPSendResp (VAR pBlockPtr:ATPSendRespRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ATRemoveTimer (VAR pBlockPtr:ATInstallTimerRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  DDPCloseSocket (VAR pBlockPtr:DDPCloseSocketRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  DDPOpenSocket (VAR pBlockPtr:DDPOpenSocketRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  DDPSendDatagram (VAR pBlockPtr:DDPSendDatagramRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  LAPAttachProt (VAR pBlockPtr:LAPAttachProtRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  LAPReadBuffer (VAR pBlockPtr:LAPReadBufferRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  LAPRemoveProt (VAR pBlockPtr:LAPRemoveProtRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  LAPWrite (VAR pBlockPtr:LAPWriteRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  NBPConfirmName (VAR pBlockPtr:NBPConfirmNameRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  NBPKill (VAR pBlockPtr:NBPKillRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  NBPLookupName (VAR pBlockPtr:NBPLookupNameRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  NBPRegisterName (VAR pBlockPtr:NBPRegisterNameRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  NBPRemoveName (VAR pBlockPtr:NBPRemoveNameRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PAPClose (VAR pBlockPtr:PAPCloseRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PAPOpen (VAR pBlockPtr:PAPOpenRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PAPRead (VAR pBlockPtr:PAPReadRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PAPStatus (VAR pBlockPtr:PAPStatusRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PAPUnload (VAR pBlockPtr:PAPUnloadRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PAPWrite (VAR pBlockPtr:PAPWriteRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIAccess (VAR pBlockPtr:PFIAccessRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIConvertTime (VAR pBlockPtr:PFIConvertTimeRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIGetSrcPath (VAR pBlockPtr:PFIGetSrcpathRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIGetSVersion (VAR pBlockPtr:PFIGetSVersionRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIHooks (VAR pBlockPtr:PFIHooksRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIListSessions (VAR pBlockPtr:PFIListSessionsRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIListSessions2 (VAR pBlockPtr:PFIListSessions2Rec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFILogin (VAR pBlockPtr:PFILoginRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFILogin2 (VAR pBlockPtr:PFILogin2Rec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFILoginCont (VAR pBlockPtr:PFILoginContRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFILogOut (VAR pBlockPtr:PFILogoutRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIMountVol (VAR pBlockPtr:PFIMountvolRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFINaming (VAR pBlockPtr:PFINamingRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFISetBuffer (VAR pBlockPtr:PFISetBufferRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFITimeZone (VAR pBlockPtr:PFITimeZoneRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  PFIUserPrefix (VAR pBlockPtr:PFIUserPrefixRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  RPMCloseSession (VAR pBlockPtr:RPMCloseSessionRecPtr) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  RPMFlushSession (VAR pBlockPtr:RPMFlushSessionRecPtr) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  RPMSetPrinter (VAR pBlockPtr:RPMSetPrinterRecPtr) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ZIPGetMyZone (VAR pBlockPtr:ZIPGetMyZoneRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;
FUNCTION  ZIPGetZoneList (VAR pBlockPtr:ZIPGetZoneListRec) : OSErr ;
       INLINE $FA,$7A,$E1101422,$0183;

IMPLEMENTATION

END.
